//
//  MCPQualifierRegistry.h
//  MCFoundation
//
//  Created by Michael Clark on 22/03/07.
//  Copyright 2007 __MyCompanyName__. All rights reserved.
//

#import <Foundation/Foundation.h>

@class BDQualifier;

@interface MCPQualifierRegistry : NSObject {

	NSMutableDictionary*    __qualifierConfigRegistry;  // Stores the qualifier configs from which they are instantiated
	NSMutableDictionary*    __qualifierRegistry;  // Stores the instantiated qualifiers
}

+ (MCPQualifierRegistry*)defaultInstance;

- (void)loadQualifierConfigsAtPath: (NSString*)path;
	// Takes a path to a plist which contains configs for qualifiers - generally created with MCAppConfigurator


- (void)registerQualifier: (BDQualifier*)qualifier forName: (NSString*)name;
	// Method that allows the registration of an already instantiated qualifier
- (void)registerQualifier: (BDQualifier*)qualifier forName: (NSString*)name entityName: (NSString*)entityName;

- (BDQualifier*)qualifierForName: (NSString*)name bindings: (NSDictionary*)bindings requiresAllVariables:(BOOL)requiresAll;
	// Returns a copy of the registered qualifier with the binding values subbed in.  If YES is passed for requiresAll then if a sub qualifier doesn't find its variable in the bindings an exception is thrown, otherwise the sub qualifier will be dropped from the expression

- (BDQualifier*)qualifierForName: (NSString*)name entityName: (NSString*)entityName bindings: (NSDictionary*)bindings requiresAllVariables:(BOOL)requiresAll;

@end
